function moveUp(%val)
{
	if($battleInProgress)
	{
		if($battleMenuActive && %val)
			moveMenuUp();
		return;
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() == $zoomOutCutoff)
		return;
	
	if(%val)
	{
		$MovingUp = 1;
		$LastMovement = "Up";
	}else{
		$MovingUp = 0;
	}
}

function moveDown(%val)
{
	if($battleInProgress)
	{
		if($battleMenuActive && %val)
			moveMenuDown();
		return;
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() == $zoomOutCutoff)
		return;
	
	if(%val)
	{
		$MovingDown = 1;
		$LastMovement = "Down";
	}else{
		$MovingDown = 0;
	}
}

function moveLeft(%val)
{
	if($battleInProgress)
	{
		if($battleMenuActive && %val)
			moveMenuLeft();
		return;
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() == $zoomOutCutoff)
		return;
	
	if(%val)
	{
		$MovingLeft = 1;
		$LastMovement = "Left";
	}else{
		$MovingLeft = 0;
	}
}

function moveRight(%val)
{
	if($battleInProgress)
	{
		if($battleMenuActive && %val)
			moveMenuRight();
		return;
	}
	
	if(sceneWindow2D.getCurrentCameraZoom() == $zoomOutCutoff)
		return;
	
	if(%val)
	{
		$MovingRight = 1;
		$LastMovement = "Right";
	}else{
		$MovingRight = 0;
	}
}

function doPowerHit(%val)
{
	if(!%val)
		return;
	
	if($allowBattleClose)
	{
		doBattleClose();
		return;
	}
	
	if($battleMenuActive == 1)
	{
		eval($menu[$menuRowSelected @ "_" @ $menuColSelected @ "Cmd"]);
		setButtonStates();
		return;
	}
	
	if($didPowerHit)
		return;
	
	if($waitingForPowerHit)
	{
		if($showPowerHitIndicator)
			$powerHitIndicator.setVisible(0);
		$powerHitSucceed = 1;
	}
	
	$didPowerHit = 1;
}

//row_col
$totalRows = 2;

//object names of the buttons on first section only (constant)
$menu0_0 = btnFight;
$menu0_0Cmd = "setMenuRow(1);";
$menu0_1 = btnMenu;
$menu0_2 = btnFlee;
$menu0_count = 3;

//object names and text values
$menu1_0 = "btnMove1";
$menu1_0TextVal = "Attack";
$menu1_0Cmd = "playerAttack();";
$menu1_1 = "btnMove2";
$menu1_1TextVal = "Fart";
$menu1_2 = "btnMove3";
$menu1_2TextVal = "Cat";
$menu1_3 = "btnMove4";
$menu1_3TextVal = "Apple";
$menu1_count = 4;
$menu1_AllowUpDown = 1;

function setMenuRow(%row)
{
	$menuRowSelected = %row;
	%menuColSelected = 0;
}

function moveMenuLeft()
{
	if($menuColSelected > 0)
	{
		$menuColSelected--;
		setButtonStates();
	}
}

function moveMenuRight()
{
	if($menuColSelected < $menu[$menuRowSelected @ "_Count"] - 1)
	{
		$menuColSelected++;
		setButtonStates();
	}
}

function moveMenuUp()
{
	if($menu[$menuRowSelected @ "_AllowUpDown"] && $menuColSelected - 1 > 0)
	{
		$menuColSelected -= 2;
		setButtonStates();
	}
}

function moveMenuDown()
{
	if($menu[$menuRowSelected @ "_AllowUpDown"] && $menuColSelected < $menu[$menuRowSelected @ "_Count"] - 2)
	{
		$menuColSelected += 2;
		setButtonStates();
	}
}

function setButtonStates()
{
	//first set (special)
	%r = 0;
	for(%c = 0; %c < $menu[%r @ "_Count"]; %c++)
	{
		if(%r == $menuRowSelected && %c == $menuColSelected && $battleMenuActive)
		{
			eval($menu[%r @ "_" @ %c] @ ".setBitmap(\"game/data/images/ui/" @ $menu[%r @ "_" @ %c] @ "_Selected\");");
		}else{
			eval($menu[%r @ "_" @ %c] @ ".setBitmap(\"game/data/images/ui/" @ $menu[%r @ "_" @ %c] @ "\");");
		}
	}
	
	//all other sets of menus
	for(%r = 1; %r < $totalRows; %r++)
	{
		for(%c = 0; %c < $menu[%r @ "_Count"]; %c++)
		{
			if(%r == $menuRowSelected && %c == $menuColSelected && $battleMenuActive)
			{
				eval($menu[%r @ "_" @ %c] @ "Text.profile = GuiMoveNameSelectedProfile;");
				eval($menu[%r @ "_" @ %c] @ ".setBitmap(\"game/data/images/ui/btnBack_Selected\");");
			}else{
				eval($menu[%r @ "_" @ %c] @ "Text.profile = GuiMoveNameProfile;");
				eval($menu[%r @ "_" @ %c] @ ".setBitmap(\"game/data/images/ui/btnBack\");");
			}
			
			if(%r <= $menuRowSelected)
			{
				eval($menu[%r @ "_" @ %c] @ "Text.setText(\"" @ $menu[%r @ "_" @ %c @ "TextVal"] @ "\");");
				eval($menu[%r @ "_" @ %c] @ ".setVisible(1);");
				eval($menu[%r @ "_" @ %c] @ "Text.setVisible(1);");
			}else{
				eval($menu[%r @ "_" @ %c] @ ".setVisible(0);");
				eval($menu[%r @ "_" @ %c] @ "Text.setVisible(0);");
			}
		}
	}
}

function resetBattleGui()
{
	$menuRowSelected = 0;
	$menuColSelected = 0;
	setButtonStates();
}
